"use client"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { CardContent } from "@/components/ui/card"
import { CheckCircle2, Loader2 } from "lucide-react"

export function NewsletterSubscription() {
  const [email, setEmail] = useState("")
  const [status, setStatus] = useState<"idle" | "loading" | "success" | "error">("idle")

  const handleSubmit = async (e: React.FormEvent) => {
    e.preventDefault()
    if (!email) return

    setStatus("loading")
    
    // Simulate API call
    await new Promise(resolve => setTimeout(resolve, 1500))
    
    setStatus("success")
    setEmail("")
  }

  if (status === "success") {
    return (
      <CardContent className="p-6 space-y-4 text-center animate-in fade-in zoom-in duration-300">
        <div className="flex justify-center">
          <CheckCircle2 className="h-12 w-12 text-secondary-foreground" />
        </div>
        <h3 className="font-bold text-lg">You're subscribed!</h3>
        <p className="text-sm opacity-90">
          Check your inbox for the latest oncology updates.
        </p>
        <Button 
          variant="secondary" 
          className="w-full font-bold"
          onClick={() => setStatus("idle")}
        >
          Done
        </Button>
      </CardContent>
    )
  }

  return (
    <CardContent className="p-6 space-y-4">
      <h3 className="font-bold">Newsletter</h3>
      <p className="text-sm opacity-90">
        Get weekly oncology news and research updates delivered to your inbox.
      </p>
      <form onSubmit={handleSubmit} className="space-y-3">
        <Input
          type="email"
          placeholder="Enter your email"
          value={email}
          onChange={(e) => setEmail(e.target.value)}
          required
          className="bg-primary-foreground/10 border-primary-foreground/20 text-primary-foreground placeholder:text-primary-foreground/50 h-10"
        />
        <Button 
          type="submit" 
          variant="secondary" 
          className="w-full font-bold shadow-lg h-10"
          disabled={status === "loading"}
        >
          {status === "loading" ? (
            <Loader2 className="h-4 w-4 animate-spin" />
          ) : (
            "Subscribe Now"
          )}
        </Button>
      </form>
    </CardContent>
  )
}
