"use client"
import { useState } from "react"
import { ShieldAlert, X } from "lucide-react"

export function MedicalDisclaimerBanner() {
  const [isVisible, setIsVisible] = useState(true)

  if (!isVisible) return null

  return (
    <div className="bg-primary/95 text-primary-foreground py-3 relative z-50 border-b border-primary-foreground/10">
      <div className="container mx-auto px-4 pr-12">
        <div className="flex items-start md:items-center gap-3">
          <ShieldAlert className="h-5 w-5 shrink-0 mt-0.5 md:mt-0 opacity-80" />
          <p className="text-xs md:text-sm font-medium leading-tight">
            <span className="font-bold underline">Important:</span> Information on OncoConnect is for educational and
            support purposes only. It is <span className="italic">not</span> medical advice. Always consult with a
            qualified oncologist for diagnosis and treatment plans.
          </p>
        </div>
      </div>
      <button
        onClick={() => setIsVisible(false)}
        className="absolute right-4 top-1/2 -translate-y-1/2 p-1 hover:bg-white/10 rounded-full transition-colors"
        aria-label="Close disclaimer"
      >
        <X className="h-4 w-4" />
      </button>
    </div>
  )
}
