"use client"

import {
  AlertDialog,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from "@/components/ui/alert-dialog"
import { Button } from "@/components/ui/button"
import { PhoneCall, HeartHandshake } from "lucide-react"
import { useState, useEffect } from "react"
import { fetchApi } from "@/lib/api-client"

export function CrisisSupport() {
  const [content, setContent] = useState<any>({})

  useEffect(() => {
    fetchApi('content.php?page=crisis').then(setContent).catch(console.error)
  }, [])

  return (
    <AlertDialog>
      <AlertDialogTrigger asChild>
        <Button variant="destructive" size="sm" className="gap-2 font-bold shadow-lg shadow-destructive/20">
          <PhoneCall className="h-4 w-4" />
          Seek Immediate Help
        </Button>
      </AlertDialogTrigger>
      <AlertDialogContent className="max-w-md">
        <AlertDialogHeader>
          <div className="mx-auto w-12 h-12 rounded-full bg-destructive/10 flex items-center justify-center mb-2">
            <HeartHandshake className="h-6 w-6 text-destructive" />
          </div>
          <AlertDialogTitle className="text-center text-xl">You are not alone.</AlertDialogTitle>
          <AlertDialogDescription className="text-center space-y-4">
            <p className="text-foreground font-medium">
              If you or someone you know is in immediate danger or emotional distress, help is available right now.
            </p>
            <div className="grid grid-cols-1 gap-3 text-left">
              <div className="p-4 rounded-xl bg-muted/50 border space-y-1">
                <p className="text-xs font-bold uppercase text-muted-foreground">National Cancer Institute</p>
                <p className="font-bold">{content.nci?.phone || "1-800-4-CANCER (1-800-422-6237)"}</p>
                <p className="text-[10px] text-muted-foreground">{content.nci?.hours || "Monday-Friday, 9:00 a.m. to 9:00 p.m. ET"}</p>
              </div>
              <div className="p-4 rounded-xl bg-destructive/5 border border-destructive/10 space-y-1">
                <p className="text-xs font-bold uppercase text-destructive/70">988 Suicide & Crisis Lifeline</p>
                <p className="font-bold text-destructive text-lg">{content.lifeline?.phone || "Call or Text 988"}</p>
                <p className="text-[10px] text-destructive/70">{content.lifeline?.availability || "Available 24/7, free, and confidential"}</p>
              </div>
            </div>
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter className="flex-col sm:flex-col gap-2 mt-4">
          <Button asChild className="w-full bg-destructive hover:bg-destructive/90 font-bold">
            <a href={`tel:${content.lifeline?.phone?.match(/\d+/g)?.join('') || '988'}`}>Call Now</a>
          </Button>
          <AlertDialogCancel className="w-full border-none hover:bg-muted font-medium">Close</AlertDialogCancel>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  )
}
