"use client"

import { Button } from "@/components/ui/button"
import { PlusCircle } from "lucide-react"
import Link from "next/link"
import { useAuth } from "@/components/auth-provider"

export function CreateInsightButton() {
  const { user } = useAuth()

  if (user?.role !== "expert") {
    return null
  }

  return (
    <Button size="lg" className="gap-2 shadow-lg" asChild>
      <Link href="/insights/create">
        <PlusCircle className="h-5 w-5" />
        Create Expert Article
      </Link>
    </Button>
  )
}
