"use client"

import { Button } from "@/components/ui/button"
import { PlusCircle } from "lucide-react"
import Link from "next/link"
import { useAuth } from "@/components/auth-provider"

export function AskQuestionButton() {
  const { user } = useAuth()

  return (
    <Button size="lg" className="gap-2 shadow-lg" asChild>
      <Link href={user ? "/forum/ask" : "/login?callbackUrl=/forum/ask"}>
        <PlusCircle className="h-5 w-5" />
        Ask a Question
      </Link>
    </Button>
  )
}
