import { fetchApi } from "@/lib/api-client"

export default async function TermsPage() {
  let content: any = {};
  try {
    const data = await fetchApi('content.php?page=terms');
    content = data.content?.body ? JSON.parse(data.content.body) : null;
  } catch (error) {
    console.error("Failed to fetch terms content:", error);
  }

  const sections = content?.sections || [
    {
      title: "1. Acceptance of Terms",
      text: "By accessing or using OncoConnect, you agree to be bound by these Terms of Service and all applicable laws and regulations."
    },
    {
      title: "2. Medical Disclaimer",
      text: "OncoConnect is NOT a substitute for professional medical advice, diagnosis, or treatment. Always seek the advice of your physician or other qualified health provider with any questions you may have regarding a medical condition."
    },
    {
      title: "3. User Conduct",
      text: "Users are expected to maintain a respectful and empathetic environment. Harassment, misinformation, and unsolicited medical advice are strictly prohibited and may lead to account suspension."
    }
  ];

  return (
    <main className="flex-1 container mx-auto px-4 py-16 max-w-3xl">
      <h1 className="text-3xl font-bold mb-8">Terms of Service</h1>
      <div className="prose prose-sm prose-slate max-w-none space-y-6">
        <p className="text-muted-foreground">Last Updated: {content?.last_updated || "December 28, 2024"}</p>
        {sections.map((section: any, index: number) => (
          <section key={index}>
            <h2 className="text-xl font-bold mt-8 mb-4">{section.title}</h2>
            <p className={section.title.includes("Disclaimer") ? "font-bold" : ""}>
              {section.text}
            </p>
          </section>
        ))}
      </div>
    </main>
  )
}
