import { fetchApi } from "@/lib/api-client"

export default async function PrivacyPage() {
  let content: any = {};
  try {
    const data = await fetchApi('content.php?page=privacy');
    content = data.content?.body ? JSON.parse(data.content.body) : null;
  } catch (error) {
    console.error("Failed to fetch privacy content:", error);
  }

  const sections = content?.sections || [
    {
      title: "1. Information We Collect",
      text: "OncoConnect collects information to provide better services to our community members. This includes: Account information (name, email), Profile information (role as patient/caregiver), and Community contributions (forum posts, comments)."
    },
    {
      title: "2. How We Use Your Information",
      text: "We use the information we collect to maintain and improve our services, facilitate community interactions, and provide relevant medical information. We do NOT share your personal health information with third parties for marketing purposes."
    },
    {
      title: "3. Data Security",
      text: "We implement industry-standard security measures to protect your data. However, please be aware that no method of electronic transmission is 100% secure."
    }
  ];

  return (
    <main className="flex-1 container mx-auto px-4 py-16 max-w-3xl">
      <h1 className="text-3xl font-bold mb-8">Privacy Policy</h1>
      <div className="prose prose-sm prose-slate max-w-none space-y-6">
        <p className="text-muted-foreground">Last Updated: {content?.last_updated || "December 28, 2024"}</p>
        {sections.map((section: any, index: number) => (
          <section key={index}>
            <h2 className="text-xl font-bold mt-8 mb-4">{section.title}</h2>
            <p>{section.text}</p>
          </section>
        ))}
      </div>
    </main>
  )
}
