import { ShieldCheck, Scale, AlertTriangle, Users } from "lucide-react"
import { fetchApi } from "@/lib/api-client"

export default async function ModerationPage() {
  let content: any = {};
  try {
    content = await fetchApi('content.php?page=moderation');
  } catch (error) {
    console.error("Failed to fetch moderation content:", error);
  }

  return (
    <main className="flex-1 container mx-auto px-4 py-16 max-w-3xl">
      <div className="flex items-center gap-3 mb-8">
        <div className="p-3 rounded-2xl bg-primary/10">
          <ShieldCheck className="h-8 w-8 text-primary" />
        </div>
        <div>
          <h1 className="text-3xl font-bold">{content.guidelines?.title || "Moderation Guidelines"}</h1>
          <p className="text-muted-foreground text-pretty">{content.guidelines?.subtitle || "Keeping OncoConnect a safe and reliable space."}</p>
        </div>
      </div>

      <div className="space-y-12">
        <section className="space-y-4">
          <div className="flex items-center gap-2 font-bold text-xl">
            <Scale className="h-5 w-5 text-secondary" />
            Our Core Principles
          </div>
          <p className="text-muted-foreground leading-relaxed">
            {content.principles?.text || "OncoConnect is moderated by a combination of volunteer community members and professional oncology coordinators. Our primary goal is to foster a supportive environment while preventing the spread of harmful misinformation."}
          </p>
        </section>

        <section className="grid sm:grid-cols-2 gap-8">
          <div className="space-y-4 p-6 rounded-xl bg-muted/50 border">
            <h3 className="font-bold flex items-center gap-2">
              <Users className="h-4 w-4 text-primary" />
              User Responsibilities
            </h3>
            <ul className="list-disc pl-5 space-y-2 text-sm text-muted-foreground">
              <li>Share experiences, not medical prescriptions.</li>
              <li>Cite sources when sharing research data.</li>
              <li>Maintain patient privacy (don't share names/IDs).</li>
              <li>Flag content that promotes &quot;miracle cures&quot;.</li>
            </ul>
          </div>

          <div className="space-y-4 p-6 rounded-xl bg-destructive/5 border border-destructive/10">
            <h3 className="font-bold flex items-center gap-2 text-destructive">
              <AlertTriangle className="h-4 w-4" />
              Prohibited Content
            </h3>
            <ul className="list-disc pl-5 space-y-2 text-sm text-destructive/80">
              <li>Giving specific medical advice or dosages.</li>
              <li>Promoting non-FDA approved treatments as cures.</li>
              <li>Harassment or &quot;toxic positivity&quot;.</li>
              <li>Spam, commercial solicitations, or clinical trial recruiting without approval.</li>
            </ul>
          </div>
        </section>

        <section className="space-y-4">
          <h2 className="text-xl font-bold">How We Handle Violations</h2>
          <p className="text-sm text-muted-foreground leading-relaxed">
            Content flagged as &quot;Medical Misinformation&quot; is reviewed within 4 hours by our verification team.
            Depending on the severity, violations may result in a warning, content removal, or permanent account
            suspension.
          </p>
        </section>
      </div>
    </main>
  )
}
