import { ForumList } from "@/components/forum-list"
import { ForumSidebar } from "@/components/forum-sidebar"
import { Button } from "@/components/ui/button"
import { PlusCircle, Search } from "lucide-react"
import { Input } from "@/components/ui/input"
import { fetchApi } from "@/lib/api-client"
import Link from "next/link"
import { AskQuestionButton } from "@/components/ask-question-button"

export default async function ForumPage({
  searchParams,
}: {
  searchParams: Promise<{ q?: string }>
}) {
  const { q: searchQuery = "" } = await searchParams
  let content: any = {}
  try {
    content = await fetchApi('content.php?page=forum')
  } catch (error) {
    console.error("Failed to fetch forum content:", error)
  }

  return (
    <main className="flex-1 bg-muted/30">
      <div className="container mx-auto px-4 py-8">
        <div className="flex flex-col md:flex-row items-start md:items-center justify-between gap-4 mb-8">
          <div className="space-y-1">
            <h1 className="text-3xl font-bold tracking-tight">{content.header?.title || "Q&A Forum"}</h1>
            <p className="text-muted-foreground">
              {content.header?.description || "Ask questions and share experiences with our community of patients and caregivers."}
            </p>
          </div>
          <AskQuestionButton />
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-12 gap-8">
          {/* Main Forum Content */}
          <div className="lg:col-span-8 space-y-6">
            <form className="relative">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
              <Input
                name="q"
                placeholder="Filter by keywords or tags..."
                className="pl-10 h-12 bg-background border-none shadow-sm"
                defaultValue={searchQuery}
              />
            </form>

            <ForumList searchQuery={searchQuery} />
          </div>

          {/* Sidebar */}
          <aside className="lg:col-span-4 space-y-8">
            <ForumSidebar />
          </aside>
        </div>
      </div>
    </main>
  )
}
